/**
* @author Remy Sharp
* @url http://remysharp.com/2007/01/25/jquery-tutorial-text-box-hints/
*/

(function ($) {

$.fn.hint = function (blurClass) {
  if (!blurClass) { 
    blurClass = 'blur';
  }
    
  return this.each(function () {
    // get jQuery version of 'this'
    var $input = $(this),
    
    // capture the rest of the variable to allow for reuse
      $win = $(window);

    function remove() {
      if ($input.hasClass(blurClass)) {
        $input.val('').removeClass(blurClass).css("color","#000");
      }
    }

	if ($input.hasClass('textstyle')) {
    // only apply logic if the element has the attribute
    if ($input.attr('title') != '') { 
      // on blur, set value to title attr if text is blank
      $input.blur(function () {
        if (this.value === '') {
          $input.val($input.attr('title')).addClass(blurClass).css("color","#f00");;
        }
      }).focus(remove).blur(); // now change all inputs to title
      
      $win.unload(remove); // handles Firefox's autocomplete
    }
	else
	  $input.removeClass(blurClass);
	}
  });
};

})(jQuery);